function resid = fault_slip_resid_bound_cheb(a,alpha,b,cheb_terms,...
    ddelta_dy_hat,delta,delta_c,D_center,eps_reg,eta_reg,flag_coupled,...
    flag_fric,flag_merged,flag_reg,g,G,kappa,K_eff,mu_dyn,mu_st,nu,p_0_center,...
    p_inc,phi,rho_f,rho_s,sigma_v_0,theta,T,y_bound,y_bound_cross,y_delta)
%
% Computes residuals in the form of coefficients c_0 and c_1 of an expansion of minus sigma_C
% (uncoupled case) or minus sigma_C plus sigma_breve_cross (coupled case) in first-kind
% Chebyshev polynomials. 
%
N = cheb_terms; % number of terms in Chebyshev expansion
T_0_1 = T(:,1:2); % selects first two columns representing T_0 and T_1
if y_bound(1) > y_bound(2) % swap values in exceptional case that they are wrongly ordered
    temp = y_bound(1);
    y_bound(1) = y_bound(2);
    y_bound(2) = temp;
end
y_minus = y_bound(1);
y_plus = y_bound(2);
z_j = -cos( pi*((1:N)-0.5)/N ); % first-kind Chebyshev points
Delta_y =   y_plus-y_minus;
y_barbar = (y_minus+y_plus)/2;
y_j = y_barbar + z_j * Delta_y/2; % rescaled Chebyshev points; y_minus < y < y_plus
[~,~,~,sigma_C] = ...
    fault_slip_sigma(a,alpha,b,delta,delta_c,D_center,eps_reg,eta_reg,...
    flag_fric,flag_reg,g,kappa,K_eff,mu_dyn,mu_st,N,nu,p_0_center,p_inc,...
    phi,rho_f,rho_s,sigma_v_0,theta,y_delta,y_j,y_j);
if flag_coupled == 0 || flag_merged == 1 
    resid = (2/N) * -sigma_C * T_0_1;  
else
    sigma_breve_cross = fault_slip_sigma_breve_cheb(ddelta_dy_hat,cheb_terms,G,nu,T,...
        y_bound,y_bound_cross,y_j);
    resid = (2/N) * (-sigma_C + sigma_breve_cross) * T_0_1;  
end